*-----------------------------------------------------------.
*SPSS SYNTAX FOR READING IN DATA FROM THE ONLINE TOOLKIT FOR PROCESSING THE PUBLIC PROCUREMENT OF GRAD ZAGREB AND ZAGREB HOLDING. 
*CREATED BY MIKLS HAJDU (senior researcher, CRCB) ON 17/10/2017.
*HEAD of RESEARCH: ISTVAN JANOS TTH (director, CRCB)
*
*CORRUPTION RESEARCH CENTER BUDAPEST (CRCB)
*
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*CONTENTS:.
*READING IN THE DATASET EXPORTED FROM THE ONLINE TOOLKIT.
*LABELING VARIABLES AND VALUES.
*CREATING THE SECTOR VARIABLES BASED ON THE CPV CODES.
*CREATING THE YEAR VARIABLE.
*CREATING THE YEAR AND QUARTER (DATE) VARIABLE.
*CREATING THE NET CONTRACT VALUE VARIABLE.
*CREATING THE OPEN PROCUREMENT TYPE VARIABLE.
*CREATING THE SINGLE BIDDER VARIABLE.
*CREATING THE INDICATOR OF COMPETITIVE INTENSITY VARIABLES.
*CREATING THE FILTER VARIABLE.
*TURNING THE FILTER ON.
*PREPARING FIGURE 1.1.:  YEARLY NUMBER OF CONTRACTS.
*PREPARING FIGURE 1.2.:  AGGREGATED NET CONTRACT VALUES PER YEAR.
*PREPARING FIGURE 1.3.:  DISTRIBUTION OF CONTRACTS BY ISSUER.
*PREPARING FIGURE 1.4.:  AGGREGATED NET CONTRACT VALUES PER YEAR BY ISSUER .
*PREPARING FIGURE 1.5.:  DISTRIBUTION OF CONTRACTS BY VAT IN THEIR VALUES.
*PREPARING FIGURE 1.6.:  SHARE OF CONTRACTS DERIVING FROM OPEN PROCUREMENT PROCEDURES.
*PREPARING FIGURE 1.7.:  DISTRIBUTION OF CONTRACTS BY SECTOR.
*PREPARING FIGURE 3.1.:  SHARE OF TENDERS WITHOUT COMPETITION (SB) BY QUARTER.
*PREPARING FIGURE 3.2.:  SHARE OF TENDERS WITHOUT COMPETITION (SB) BY YEAR.
*PREPARING FIGURE 3.7.:  SHARE OF TENDERS WITHOUT COMPETITION (SB) BY YEAR AND SECTOR.
*PREPARING FIGURE 3.8.:  THE MAIN VALUE OF INDICATOR OF COMPETITIVE INTENSITY (ICI). 
*PREPARING FIGURE 3.10.: THE VALUE OF INDICATOR OF COMPETITIVE INTENSITY (ICI) BY YEAR AND SECTOR.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*READING IN THE DATASET EXPORTED FROM THE ONLINE TOOLKIT.
*THE DIRECTORY AND THE FILENAME HAVE TO BE DEFINED IN THE THIRD LINE OF THE COMMAND BETWEEN THE QUOTATION MARKS.
*-----------------------------------------------------------.
*COMMAS HAS TO BE RECOGNIZED AS DECIMAL SEPARATOR, THEREFORE WE SET SYTEM LOCALE TO HUNGARIAN.
SET LOCALE = HU_HU.
GET DATA  /TYPE=TXT
  /FILE="Z:\Downloads\cms_dataset_08-10-2017.csv"
  /DELCASE=LINE
  /DELIMITERS=","
  /QUALIFIER='"'
  /ARRANGEMENT=DELIMITED
  /FIRSTCASE=2
  /IMPORTCASE=ALL
  /VARIABLES=
  id F3.0
  sid F1.0
  issuer F1.0
  doc_id F1.0
  oib F11.0
  dscrptn A306
  c_type1 F1.0
  c_type2 A24
  nuts_code A2
  c_descr A913
  cpv A40
  frmw F1.0
  c_devise A3
  c_vat_d F1.0
  c_vat_prc A2
  p_type A51
  cr_type A15
  c_code A16
  prev_doc_d F1.0
  prev_doc_type F1.0
  prev_doc_code F1.0
  prev_doc_date F1.0
  c_num1 F3.0
  c_num2 F1.0
  n_bidder F2.0
  w_name A92
  w_addr1 A34
  w_addr2 A21
  w_addr_zip F5.0
  c_value_est F11.2
  c_value_est_devise A3
  c_value_est_vat_d F1.0
  c_value_est_vat_prc F1.0
  c_value F11.2
  c_value_devise A3
  c_value_vat_d F1.0
  c_value_vat_prc F1.0
  c_subcontr_d F1.0
  c_subcontr_value F1.0
  c_subcontr_def F1.0
  eu F1.0
  eu_def F1.0
  disp_res_name A52
  d_addr1 A22
  d_addr2 A14
  d_addr_zip F5.0
  date A10
  company_id F4.0
  source_url F1.0
  co_name A92
  co_bn_name A31
  co_addr1 A35
  co_addr2 A21
  co_addr_zip F5.0
  co_reg_num F12.0
  co_sector_id F5.2
  co_tax_num F7.0
  co_reg_num2 F10.0
  co_foreign_owner A20
  co_private_owner A20
  co_found_yr F4.0
  state_payments_2012 F1.0
  state_payments_2013 F10.2
  state_payments_2014 F9.2
  state_payments_2015 F11.2
  state_payments_2016 F11.2
  state_payments_2017 F10.2
  employees_2012 F3.0
  employees_2013 F3.0
  employees_2014 F3.0
  employees_2015 F3.0
  employees_2016 F3.0
  employees_2017 F1.0
  labor_costs_2012 F8.0
  labor_costs_2013 F8.0
  labor_costs_2014 F8.0
  labor_costs_2015 F8.0
  labor_costs_2016 F8.0
  labor_costs_2017 F1.0
  turnover_2012 F9.0
  turnover_2013 F8.0
  turnover_2014 F9.0
  turnover_2015 F9.0
  turnover_2016 F9.0
  turnover_2017 F1.0
  net_profit_2012 F10.0
  net_profit_2013 F9.0
  net_profit_2014 F9.0
  net_profit_2015 F8.0
  net_profit_2016 F7.0
  net_profit_2017 F1.0
  export_sales_2012 F6.0
  export_sales_2013 F6.0
  export_sales_2014 F7.0
  export_sales_2015 F7.0
  export_sales_2016 F6.0
  export_sales_2017 F1.0
  assets_2012 F9.0
  assets_2013 F9.0
  assets_2014 F9.0
  assets_2015 F9.0
  assets_2016 F9.0
  assets_2017 F1.0
  loan_2012 F9.0
  loan_2013 F9.0
  loan_2014 F9.0
  loan_2015 F8.0
  loan_2016 F8.0
  loan_2017 F1.0
  altman_2012 F5.2
  altman_2013 F5.2
  altman_2014 F4.2
  altman_2015 F4.2
  altman_2016 F4.2
  altman_2017 F1.0.
CACHE.
EXECUTE.
DATASET NAME DataSet1 WINDOW=FRONT.


*-----------------------------------------------------------.
*LABELING VARIABLES AND VALUES.
*-----------------------------------------------------------.
variable label id 'ID'.
variable label sid 'SUB ID'.
variable label issuer 'Issuer'.
variable label doc_id 'Document ID'.
variable label oib 'OIB'.
variable label dscrptn 'Description of product/service'.
variable label c_type1 'Contract type'.
variable label c_type2 'Categories of contract type'.
variable label nuts_code 'NUTS code'.
variable label c_descr 'Brief description of the contract'.
variable label cpv 'CPV code'.
variable label frmw 'Framework contract'.
variable label c_devise 'Contract currency'.
variable label c_vat_d 'VAT included or not'.
variable label c_vat_prc 'VAT rate'.
variable label p_type 'Method of procedure'.
variable label cr_type 'Criteria for selecting a winner'.
variable label c_code 'Contract reference number'.
variable label prev_doc_d 'Related documents'.
variable label prev_doc_type 'Related document type'.
variable label prev_doc_code 'Related document code'.
variable label prev_doc_date 'Related document date'.
variable label c_num1 'Contract number'.
variable label c_num2 'Contract number #2'.
variable label n_bidder 'Number of bidders'.
variable label w_name 'Winners name'.
variable label w_addr1 'Winners postal address'.
variable label w_addr2 'Winners city'.
variable label w_addr_zip 'Winners postal code'.
variable label c_value_est 'Estimated Contract value'.
variable label c_value_est_devise 'Currency'.
variable label c_value_est_vat_d 'VAT included or not'.
variable label c_value_est_vat_prc 'VAT rate'.
variable label c_value 'Contract value'.
variable label c_value_devise 'Currency'.
variable label c_value_vat_d 'VAT included or not'.
variable label c_value_vat_prc 'VAT rate'.
variable label c_subcontr_d 'Subcontractors'.
variable label c_subcontr_value 'Subcontracting value'.
variable label c_subcontr_def 'Brief description of subcontracting'.
variable label eu 'EU funding'.
variable label eu_def 'Brief description of EU funding'.
variable label disp_res_name 'Name of institution acting in case of potential complaints'.
variable label d_addr1 'Acting institutions postal address'.
variable label d_addr2 'Acting institutions city'.
variable label d_addr_zip 'Acting institutions postal code'.
variable label date 'Announcement date'.
variable label company_id 'Internal company ID'.
variable label source_url 'URL of the data sheet'.
variable label co_name 'Companys name'.
variable label co_bn_name 'Companys name in Bisnode'.
variable label co_addr1 'Address'.
variable label co_addr2 'City'.
variable label co_addr_zip 'Postal code'.
variable label co_reg_num 'Company registration number'.
variable label co_sector_id 'Sector ID'.
variable label co_tax_num 'Tax number'.
variable label co_reg_num2 'Registration number'.
variable label co_foreign_owner 'Foreign ownership ratio'.
variable label co_private_owner 'Private ownership ratio'.
variable label co_found_yr 'Year of foundation'.
variable label state_payments_2012 'State payments in 2012'.
variable label state_payments_2013 'State payments in 2013'.
variable label state_payments_2014 'State payments in 2014'.
variable label state_payments_2015 'State payments in 2015'.
variable label state_payments_2016 'State payments in 2016'.
variable label state_payments_2017 'State payments in 2017'.
variable label employees_2012 'Number of employees in 2012'.
variable label employees_2013 'Number of employees in 2013'.
variable label employees_2014 'Number of employees in 2014'.
variable label employees_2015 'Number of employees in 2015'.
variable label employees_2016 'Number of employees in 2016'.
variable label employees_2017 'Number of employees in 2017'.
variable label labor_costs_2012 'Labor costs in 2012'.
variable label labor_costs_2013 'Labor costs in 2013'.
variable label labor_costs_2014 'Labor costs in 2014'.
variable label labor_costs_2015 'Labor costs in 2015'.
variable label labor_costs_2016 'Labor costs in 2016'.
variable label labor_costs_2017 'Labor costs in 2017'.
variable label turnover_2012 'Price income in 2012'.
variable label turnover_2013 'Price income in 2013'.
variable label turnover_2014 'Price income in 2014'.
variable label turnover_2015 'Price income in 2015'.
variable label turnover_2016 'Price income in 2016'.
variable label turnover_2017 'Price income in 2017'.
variable label net_profit_2012 'Net profit in 2012'.
variable label net_profit_2013 'Net profit in 2013'.
variable label net_profit_2014 'Net profit in 2014'.
variable label net_profit_2015 'Net profit in 2015'.
variable label net_profit_2016 'Net profit in 2016'.
variable label net_profit_2017 'Net profit in 2017'.
variable label export_sales_2012 'Export sales in 2012'.
variable label export_sales_2013 'Export sales in 2013'.
variable label export_sales_2014 'Export sales in 2014'.
variable label export_sales_2015 'Export sales in 2015'.
variable label export_sales_2016 'Export sales in 2016'.
variable label export_sales_2017 'Export sales in 2017'.
variable label assets_2012 'Assets in 2012'.
variable label assets_2013 'Assets in 2013'.
variable label assets_2014 'Assets in 2014'.
variable label assets_2015 'Assets in 2015'.
variable label assets_2016 'Assets in 2016'.
variable label assets_2017 'Assets in 2017'.
variable label loan_2012 'Loan in 2012'.
variable label loan_2013 'Loan in 2013'.
variable label loan_2014 'Loan in 2014'.
variable label loan_2015 'Loan in 2015'.
variable label loan_2016 'Loan in 2016'.
variable label loan_2017 'Loan in 2017'.
variable label altman_2012 'Altmans Z score in 2012'.
variable label altman_2013 'Altmans Z score in 2013'.
variable label altman_2014 'Altmans Z score in 2014'.
variable label altman_2015 'Altmans Z score in 2015'.
variable label altman_2016 'Altmans Z score in 2016'.
variable label altman_2017 'Altmans Z score in 2017'.
value label issuer 1'Grad Zagreb' 2'Zagreb Holding'.
value label c_type1 1'Radovi' 2'Roba' 3'Usluge' 9'N/A'.
value label frmw 1'da' 2'ne'.
value label c_vat_d 1'bez PDV-a' 2'S PDVom'.
value label prev_doc_d 1'da' 2'ne'.
value label c_value_est_vat_d 1'bez PDV-a' 2'S PDVom'.
value label c_value_vat_d 1'bez PDV-a' 2'S PDVom'.
value label c_subcontr_d 1'da' 2'ne'.
value label eu 1'da' 2'ne'.
EXECUTE.


*-----------------------------------------------------------.
*CREATING THE SECTOR VARIABLES BASED ON THE CPV CODES.
*-----------------------------------------------------------.
compu sector=999.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '03').
if (x2 =1) sector=3.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '09').
if (x2 =1) sector=9.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '14').
if (x2 =1) sector=14.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '09').
if (x2 =1) sector=9.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '14').
if (x2 =1) sector=14.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '15').
if (x2 =1) sector=15.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '158').
if (x2 =1) sector=15.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '16').
if (x2 =1) sector=16.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '1616').
if (x2 =1) sector=16.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '18').
if (x2 =1) sector=18.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '19').
if (x2 =1) sector=19.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '22').
if (x2 =1) sector=22.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '222').
if (x2 =1) sector=22.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '228').
if (x2 =1) sector=22.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '24').
if (x2 =1) sector=24.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '269').
if (x2 =1) sector=26.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '28').
if (x2 =1) sector=28.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '295').
if (x2 =1) sector=29.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '30').
if (x2 =1) sector=30.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '301').
if (x2 =1) sector=30.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '302').
if (x2 =1) sector=30.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '31').
if (x2 =1) sector=31.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '311').
if (x2 =1) sector=31.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '3113').
if (x2 =1) sector=31.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '312').
if (x2 =1) sector=31.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '313').
if (x2 =1) sector=31.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '314').
if (x2 =1) sector=31.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '315').
if (x2 =1) sector=31.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '316').
if (x2 =1) sector=31.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '317').
if (x2 =1) sector=31.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '3153').
if (x2 =1) sector=31.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '32').
if (x2 =1) sector=32.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '323').
if (x2 =1) sector=32.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '3232').
if (x2 =1) sector=32.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '3233').
if (x2 =1) sector=32.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '322').
if (x2 =1) sector=32.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '33').
if (x2 =1) sector=33.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '339').
if (x2 =1) sector=33.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '34').
if (x2 =1) sector=34.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '342').
if (x2 =1) sector=34.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '345').
if (x2 =1) sector=34.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '349').
if (x2 =1) sector=34.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '3413').
if (x2 =1) sector=34.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '35').
if (x2 =1) sector=35.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '36').
if (x2 =1) sector=36.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '37').
if (x2 =1) sector=37.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '378').
if (x2 =1) sector=37.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '38').
if (x2 =1) sector=38.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '39').
if (x2 =1) sector=39.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '4010').
if (x2 =1) sector=40.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '41').
if (x2 =1) sector=41.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '410').
if (x2 =1) sector=41.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '42').
if (x2 =1) sector=42.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '421').
if (x2 =1) sector=42.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '422').
if (x2 =1) sector=42.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '424').
if (x2 =1) sector=42.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '426').
if (x2 =1) sector=42.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '429').
if (x2 =1) sector=42.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '43').
if (x2 =1) sector=43.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '44').
if (x2 =1) sector=44.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '441').
if (x2 =1) sector=44.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '444').
if (x2 =1) sector=44.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '4444').
if (x2 =1) sector=44.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '45').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '450').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '451').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '4545').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '452').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '4523').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '453').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '454').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '455').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '456').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '457').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '458').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '459').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '4532').
if (x2 =1) sector=45.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '464').
if (x2 =1) sector=46.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '48').
if (x2 =1) sector=48.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '484').
if (x2 =1) sector=48.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '50').
if (x2 =1) sector=50.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '503').
if (x2 =1) sector=50.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '502').
if (x2 =1) sector=50.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '505').
if (x2 =1) sector=50.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '507').
if (x2 =1) sector=50.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '5085').
if (x2 =1) sector=50.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '51').
if (x2 =1) sector=51.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '515').
if (x2 =1) sector=51.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '5151').
if (x2 =1) sector=51.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '55').
if (x2 =1) sector=55.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '555').
if (x2 =1) sector=55.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '5520').
if (x2 =1) sector=55.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '60').
if (x2 =1) sector=60.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '601').
if (x2 =1) sector=60.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '63').
if (x2 =1) sector=63.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '64').
if (x2 =1) sector=64.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '65').
if (x2 =1) sector=65.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '653').
if (x2 =1) sector=65.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '66').
if (x2 =1) sector=66.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '666').
if (x2 =1) sector=66.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '70').
if (x2 =1) sector=70.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '71').
if (x2 =1) sector=71.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '7131').
if (x2 =1) sector=71.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '72').
if (x2 =1) sector=72.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '722').
if (x2 =1) sector=72.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '727').
if (x2 =1) sector=72.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '73').
if (x2 =1) sector=73.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '74').
if (x2 =1) sector=74.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '75').
if (x2 =1) sector=75.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '76').
if (x2 =1) sector=76.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '764').
if (x2 =1) sector=76.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '77').
if (x2 =1) sector=77.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '7770').
if (x2 =1) sector=77.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '78').
if (x2 =1) sector=78.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '79').
if (x2 =1) sector=79.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '80').
if (x2 =1) sector=80.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '805').
if (x2 =1) sector=80.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '85').
if (x2 =1) sector=85.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '90').
if (x2 =1) sector=90.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '905').
if (x2 =1) sector=90.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '906').
if (x2 =1) sector=90.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '907').
if (x2 =1) sector=90.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '905').
if (x2 =1) sector=90.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '909').
if (x2 =1) sector=90.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '92').
if (x2 =1) sector=92.
compu x2=0.
compu x2=CHAR.RINDEX (cpv, '98').
if (x2 =1) sector=98.
missing value sector (999).
execute.
compu sector6=9.
formats sector6 (f3.0) /sector (f4.0).
if (sector = 3) sector6=6.
if ((sector ge 75 and sector lt 78) or (sector ge 80 and sector le 98)) sector6=6.
if (sector ge 9 and sector le 44) sector6=1.
if (sector = 45) sector6=2.
if (sector = 48 or sector = 72) sector6=3.
if (sector = 70 or sector = 79) sector6=4.
if (sector = 71 or sector = 73 or sector = 66) sector6=5.
if (sector = 50 or sector = 51) sector6=6.
if (sector = 60 or sector = 63 or sector = 64 or sector = 55) sector6=6.
if (sector = 65 or sector = 74) sector6=6.
if (sector = 26 or sector = 28 or sector = 40 or sector = 41 or sector = 78) sector6=6.
missing value sector6 (9).
variable labels sector6 'Sector (6 cat.)'.
value labels sector6 1 'Industry' 2 'Construction' 3 'IT' 4 'Real estate & services' 5 'Engeneering, RD, Financial services' 
  6 'Other services' 9'Unknown'.
EXECUTE.
compu sector4=9.
if (sector6 =1) sector4=1.
if (sector6 =2) sector4=2.
if (sector6 =3) sector4=3.
if (sector6 >3) sector4=4.
value label sector4 1'Industry' 2'Construction' 3 'IT' 4 'Other services' 9'Unknown'.
missing value sector4 (9).
variable labels sector4 'Sector (4 cat.)'.
EXECUTE.
del var sector x2.
formats sector4 sector6 (F1.0).
EXECUTE.
*FINAL VARIABLES: SECTOR6, SECTOR4.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*CREATING THE YEAR VARIABLE.
*-----------------------------------------------------------.
string datey(a4).
compu datey=char.substr(date,(CHAR.LENGTH(date)-3),4).
EXECUTE.
COMPUTE year=NUMBER(datey,F4.0).
var lab year 'Year'.
VARIABLE LEVEL year (ORDINAL).
formats year (F4.0).
EXECUTE.
*FINAL VARIABLE: YEAR.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*CREATING THE YEAR AND QUARTER (DATE) VARIABLE.
*-----------------------------------------------------------.
comp x1=0.
comp x1= CHAR.RINDEX(date, '.01.').
EXECUTE.
comp x2=0.
comp x2= CHAR.RINDEX(date, '.02.').
EXECUTE.
comp x3=0.
comp x3= CHAR.RINDEX(date, '.03.').
EXECUTE.
comp x4=0.
comp x4= CHAR.RINDEX(date, '.04.').
EXECUTE.
comp x5=0.
comp x5= CHAR.RINDEX(date, '.05.').
EXECUTE.
comp x6=0.
comp x6= CHAR.RINDEX(date, '.06.').
EXECUTE.
comp x7=0.
comp x7= CHAR.RINDEX(date, '.07.').
EXECUTE.
comp x8=0.
comp x8= CHAR.RINDEX(date, '.08.').
EXECUTE.
comp x9=0.
comp x9= CHAR.RINDEX(date, '.09.').
EXECUTE.
comp x10=0.
comp x10= CHAR.RINDEX(date, '.10.').
EXECUTE.
comp x11=0.
comp x11= CHAR.RINDEX(date, '.11.').
EXECUTE.
comp x12=0.
comp x12= CHAR.RINDEX(date, '.12.').
EXECUTE.

COMPUTE datey_=number(datey, f4).
comp date_=datey_*100.
formats date_ (f6.0).
EXECUTE.

comp m=0.
if (x1=3) m=1.
if (x2=3) m=2.
if (x3=3) m=3.
if (x4=3) m=4.
if (x5=3) m=5.
if (x6=3) m=6.
if (x7=3) m=7.
if (x8=3) m=8.
if (x9=3) m=9.
if (x10=3) m=10.
if (x11=3) m=11.
if (x12=3) m=12.
comp date_ = date_ + m.
EXECUTE.

comp q=9.
if (m ge 1 and m le 3) q=1.
if (m ge 4 and m le 6) q=2.
if (m ge 7 and m le 9) q=3.
if (m ge 10 and m le 12) q=4.
missing value q (9).
comp dateq=datey_*100.
formats dateq (f6.0).
EXECUTE.
comp dateq = dateq + q.
EXECUTE.
del var datey x1 x2 x3 x4 x5 x6 x7 x8 x9 x10 x11 x12 m date_ q datey_.
var lab dateq 'Date (yyyyqq)'.
*FINAL VARIABLE: DATEQ.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*CREATING THE NET CONTRACT VALUE VARIABLE.
*-----------------------------------------------------------.
if (c_value_vat_d=2) ncvalue=c_value/((100+c_value_vat_prc)/100).
if (c_value_vat_d=1) ncvalue=c_value.
*IF THE C_VALUE_VAT_D VARIABLE INDICATES THAT THE VAT IS INCLUDED IN THE PRICE, BUT THE VAT RATE IS MISSING, THE CALCULATION WILL BE BASED ON THE REGULAR 25% RATE.
if ((c_value_vat_d=2) and (MISSING(c_value_vat_prc)=1)) ncvalue=c_value/1.25.
EXECUTE.
*IF THE NET CONTRACT VALUE IS MORE THAN TEN TIMES HIGHER THAN THE ESTIMATED CONTRACT VALUE THEN WHEN SUSPECT THAT IT WAS MISPELLED, SO WE EXCLUDE IT FROM THE ANALYSIS.
compu xy=ncvalue/10.
if (xy>c_value_est) ncvalue=$SYSMIS.
COMPUTE ncvalue_err=0.
if (xy>c_value_est) ncvalue_err=1.
var lab ncvalue 'Net contract value'.
var lab ncvalue_err 'Net contract value error'.
val lab ncvalue_err 0'Net contract value OK' 1'Net contract value is more than ten times higher than the estimated contract value'.
formats ncvalue_err (F1.0).
EXECUTE.
del var xy.
*FINAL VARIABLE: NCVALUE NCVALUE_ERR.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*CREATING THE OPEN PROCUREMENT TYPE VARIABLE.
*-----------------------------------------------------------.
compu open=999.
if (p_type='Otvoreni') open=1.
if (p_type='Otvoreni postupak') open=1.
if (p_type='Pregovaraki bez prethodne objave') open=0.
if (p_type='Pregovaraki postupak bez prethodne objave') open=0.
if (p_type='Pregovaraki postupak s prethodnom objavom') open=0.
if (p_type='Sklapanje ugovora bez prethodne objave poziva na na') open=0.
if (p_type='Sklapanje ugovora o javnim uslugama iz Dodatka II.B') open=0.
mis val open (999).
val lab open 1'Open' 0'Not open' 999'NA'.
var lab open 'Procurement type'.
formats open (F3.0).
EXECUTE.
*FINAL VARIABLE: OPEN.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*CREATING THE SINGLE BIDDER VARIABLE.
*-----------------------------------------------------------.
compu sb=0.
if (n_bidder=1) sb=100.
VARIABLE LABELS sb'Single bidder'.
val lab sb 100'Single bidder' 0'Not single bidder'.
formats sb (F3.0).
exe.
*FINAL VARIABLE: SB.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*CREATING THE INDICATOR OF COMPETITIVE INTENSITY VARIABLES.
*-----------------------------------------------------------.
compu ici=99.
if (n_bidder = 2) ici=0.301.
if (n_bidder = 3 or n_bidder= 4) ici=0.544.
if (n_bidder = 5 or n_bidder= 6) ici=0.740.
if (n_bidder = 7 or n_bidder= 8) ici=0.875.
if (n_bidder > 8) ici=1.
missing value ici (99).
EXECUTE.
compu ici2=99.
if (n_bidder = 2) ici2=0.301.
if (n_bidder = 3 or n_bidder= 4) ici2=0.544.
if (n_bidder = 5 or n_bidder= 6) ici2=0.740.
if (n_bidder > 6) ici2=1.
missing value ici2 (99).
EXECUTE.
VAR LAB ici 'Indicator of Competitive Intensity'.
var lab ici2 'Indicator of Competitive Intensity (v2)'.
execute.
*FINAL VARIABLES: ICI, ICI2.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*CREATING THE FILTER VARIABLE.
*-----------------------------------------------------------.
*IDENTIFY DUPLICATE CASES.
SORT CASES BY id(A) w_name(A) c_value(A) c_value_est(A) n_bidder(A) cpv(A) date(A).
MATCH FILES
  /FILE=*
  /BY id w_name c_value c_value_est n_bidder cpv date
  /FIRST=PrimaryFirst
  /LAST=PrimaryLast.
DO IF (PrimaryFirst).
COMPUTE  MatchSequence=1-PrimaryLast.
ELSE.
COMPUTE  MatchSequence=MatchSequence+1.
END IF.
LEAVE  MatchSequence.
FORMATS  MatchSequence (f7).
COMPUTE  InDupGrp=MatchSequence>0.
SORT CASES InDupGrp(D).
MATCH FILES
  /FILE=*
  /DROP=PrimaryFirst InDupGrp MatchSequence.
VARIABLE LABELS  PrimaryLast 'Indicator of each last matching case as Primary'.
VALUE LABELS  PrimaryLast 0 'Duplicate Case' 1 'Primary Case'.
VARIABLE LEVEL  PrimaryLast (ORDINAL).
EXECUTE.
compu good=1.
if ( ncvalue = 0) good=0.
if ( PrimaryLast = 0) good=0.
formats good (f1.0).
var lab good 'Filter variable'.
val lab good 1'OK' 0'Filtered case'.
exe.
del var  PrimaryLast.
*FINAL VARIABLE: GOOD.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*TURNING THE FILTER ON.
*-----------------------------------------------------------.
filter by good.
exe.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*PREPARING FIGURE 1.1.: YEARLY NUMBER OF CONTRACTS.
*-----------------------------------------------------------.
fre year.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*PREPARING FIGURE 1.2.: AGGREGATED NET CONTRACT VALUES PER YEAR.
*-----------------------------------------------------------.
CTABLES
  /VLABELS VARIABLES=year ncvalue DISPLAY=DEFAULT
  /TABLE year BY ncvalue [SUM]
  /CATEGORIES VARIABLES=year ORDER=A KEY=VALUE EMPTY=EXCLUDE.
*-----------------------------------------------------------.  
  
  
*-----------------------------------------------------------.  
*PREPARING FIGURE 1.3.: DISTRIBUTION OF CONTRACTS BY ISSUER.
*-----------------------------------------------------------.
CROSSTABS
  /TABLES=year BY issuer
  /FORMAT=AVALUE TABLES
  /CELLS= ROW 
  /COUNT ROUND CELL.
*-----------------------------------------------------------.  
  
  
*-----------------------------------------------------------.  
*PREPARING FIGURE 1.4.: AGGREGATED NET CONTRACT VALUES PER YEAR BY ISSUER.
*-----------------------------------------------------------.
CTABLES
  /VLABELS VARIABLES=year issuer ncvalue DISPLAY=LABEL
  /TABLE year BY issuer > ncvalue [SUM]
  /CATEGORIES VARIABLES=year ORDER=A KEY=VALUE EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=issuer ORDER=A KEY=VALUE EMPTY=INCLUDE.
*-----------------------------------------------------------.  
  
  
*-----------------------------------------------------------.  
*PREPARING FIGURE 1.5.: DISTRIBUTION OF CONTRACTS BY VAT IN THEIR VALUES.
*-----------------------------------------------------------.
CROSSTABS
  /TABLES=year BY c_value_vat_d
  /FORMAT=AVALUE TABLES
  /CELLS= ROW 
  /COUNT ROUND CELL.
*-----------------------------------------------------------.

  
*-----------------------------------------------------------.  
*PREPARING FIGURE 1.6.: SHARE OF CONTRACTS DERIVING FROM OPEN PROCUREMENT PROCEDURES.
*-----------------------------------------------------------.  
CROSSTABS
  /TABLES=year BY open
  /FORMAT=AVALUE TABLES
  /CELLS= ROW 
  /COUNT ROUND CELL.  
*-----------------------------------------------------------.  


*-----------------------------------------------------------.
*PREPARING FIGURE 1.7.: Distribution of contracts by sector.
*-----------------------------------------------------------.
CROSSTABS
  /TABLES=year BY sector6
  /FORMAT=AVALUE TABLES
  /CELLS= ROW 
  /COUNT ROUND CELL.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*PREPARING FIGURE 3.1.: SHARE OF TENDERS WITHOUT COMPETITION (SB) BY QUARTER.
*-----------------------------------------------------------.
means tables sb by dateq / cells mean count.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*PREPARING FIGURE 3.2.: SHARE OF TENDERS WITHOUT COMPETITION (SB) BY YEAR.
*-----------------------------------------------------------.
means tables sb by year / cells mean count.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*PREPARING FIGURE 3.7.: SHARE OF TENDERS WITHOUT COMPETITION (SB) BY YEAR AND SECTOR.
*-----------------------------------------------------------.
means tables sb by sector4 by year / cells mean count.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*PREPARING FIGURE 3.8.: THE MAIN VALUE OF INDICATOR OF COMPETITIVE INTENSITY (ICI) BY YEAR. 
*-----------------------------------------------------------.
means tables ici by year / cells mean count.
*-----------------------------------------------------------.


*-----------------------------------------------------------.
*PREPARING FIGURE 3.10.: THE VALUE OF INDICATOR OF COMPETITIVE INTENSITY (ICI) BY YEAR AND SECTOR.
*-----------------------------------------------------------.
means tables ICI by sector4 by year / cells mean count.
*-----------------------------------------------------------.